/**
* \file: IConfiguration.cpp
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: CarPlay
*
* \author: J. Harder / ADIT/SW1 / jharder@de.adit-jv.com
*
* \copyright (c) 2013-2014 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#include <stdlib.h>
#include <limits.h>
#include <adit_logging.h>
#include "IConfiguration.h"

#include<inttypes.h>

LOG_IMPORT_CONTEXT(dipo)

namespace adit { namespace carplay
{

IConfiguration::IConfiguration()
{
}

/* ======== helper methods ======== */

std::string IConfiguration::GetItem(const std::string& key) const
{
    return GetItem(key, "");
}

std::string IConfiguration::GetItem(const std::string& key, const std::string& defaultValue) const
{
    std::string item;
    if (!TryGetItem(key, item))
    {
        LOG_WARN((dipo, "config item %s not found, default to \"%s\"", key.c_str(),
                defaultValue.c_str()));
        return defaultValue;
    }

    return item;
}

long IConfiguration::GetInt(const std::string& key) const
{
    long result = 0;

    auto item = GetItem(key, "");
    if (!item.empty())
    {
        long int converted = strtol((const char *)item.c_str(), nullptr, 0);
        if (converted >= LONG_MAX || converted <= LONG_MIN)
        {
            result = 0;
        }
        else
        {
            result = converted;
        }
    }

    return result;
}

int64_t IConfiguration::GetNumber(const std::string& key, int64_t defaultValue) const
{
    int64_t result = defaultValue;

    std::string item;
    if (TryGetItem(key, item))
    {
        char* p = nullptr;
        int64_t converted = strtoll((const char *)item.c_str(), &p, 0);
        if ((converted == LLONG_MAX || converted == LLONG_MIN) && errno == ERANGE)
        {
            LOG_WARN((dipo, "config item %s is out of range, default to %" PRId64 , key.c_str(),
                    defaultValue));
            result = defaultValue;
        }
        else if (p != nullptr && *p != '\0')
        {
            LOG_WARN((dipo, "config item %s is not a number, default to %" PRId64, key.c_str(),
                    defaultValue));
            result = defaultValue;
        }
        else
        {
            result = converted;
        }
    }

    return result;
}

} } // namespace adit { namespace carplay
